SNOW_INIT = function(snowQuad)
   snowQuad:visible(0)
   PASSIVE_SNOW_QUADS[#PASSIVE_SNOW_QUADS+1] = snowQuad
end

LERP_LINEAR = function(from, to, amount)
   return from * (1 - amount) + to * amount
end

LERP_EASE_END = function(from, to, amount)
   amount = math.sin(amount * 3.14159 * 0.5)
   return from * (1 - amount) + to * amount
end

LERP_EASE_START = function(from, to, amount)
   amount = 1.0 - math.sin((amount + 1.0) * 3.14159 * 0.5)
   return from * (1 - amount) + to * amount
end

SNOW_SMALL_SIZE = 6
SNOW_LARGE_SIZE = 8
SNOW_RENDER_SCALE = 1

PASSIVE_SNOW_QUADS = {}
ACTIVE_SNOW_QUADS = {}

SHROUD_SPRITE = nil

gStormStages = {
   { 0, 13.0, -2, 5.5, LERP_LINEAR, 0.0, 0.0 },
   { 4, 13.0, -2, 5.5, LERP_LINEAR, 0.25, 0.0 },
   { 95, 13.0, -2, 5.5, LERP_EASE_START, 0.25, 0.0 },
   { 98, 100.0, -10, 5.5, LERP_LINEAR, 0.65, 0.5 },
   { 112, 100.0, -10, 5.5, LERP_EASE_START, 0.65, 0.5 },
   { 114, 40.0, -2, 5.5, LERP_LINEAR, 0.45, 0.2 },
   { 175, 40.0, -2, 5.5, LERP_EASE_START, 0.45, 0.2 },
   { 178, 120.0, -10, 5.5, LERP_LINEAR, 0.65, 0.5 },
   { 207, 120.0, -10, 5.5, LERP_LINEAR, 0.65, 0.5 },
   { 210, 300.0, -10, 5.5, LERP_LINEAR, 0.925, 0.9 },
   { 999, 300.0, -10, 5.5, LERP_LINEAR, 0.925, 0.9 }
}
gStormStep = 1

gLastBeat = GAMESTATE:GetSongBeat()
gQuadAccum = 0.0

local mainFrame = Def.ActorFrame{}

mainFrame[#mainFrame+1] = Def.Actor{
   OnCommand=function(self)
      self:sleep(1000)
      self:visible(0)
   end,
}

mainFrame[#mainFrame+1] = Def.Actor{
   OnCommand=function(self)
      self:queuecommand('Update')
   end,
   UpdateCommand=function(self)
      local songBeat = GAMESTATE:GetSongBeat()
      local SONG_BPS = 188.24 / 60.0
      local deltaTime = (songBeat - gLastBeat) / SONG_BPS
      gLastBeat = songBeat

      while gStormStep < #gStormStages and songBeat >= gStormStages[gStormStep + 1][1] do
         gStormStep = gStormStep + 1
      end

      local lerpAmount = 0.0
      local frame0
      local frame1
      if gStormStep < #gStormStages then
         frame0 = gStormStages[gStormStep]
         frame1 = gStormStages[gStormStep + 1]
      else
         frame0 = gStormStages[gStormStep]
         frame1 = gStormStages[gStormStep]
      end
      local frameBegin = frame0[1]
      local frameEnd = frame1[1]
      lerpAmount = (songBeat - frameBegin) / (frameEnd - frameBegin)
      local snowQuadsPerSecond = frame0[5](frame0[2], frame1[2], lerpAmount)
      local xSpeed = frame0[5](frame0[3], frame1[3], lerpAmount) / 640 * SCREEN_WIDTH
      local ySpeed = frame0[5](frame0[4], frame1[4], lerpAmount) / 480 * SCREEN_HEIGHT
      local shroudAlpha = frame0[5](frame0[6], frame1[6], lerpAmount)

      if SHROUD_SPRITE ~= nil then
         SHROUD_SPRITE:diffuse(1, 1, 1, shroudAlpha)
      end

      local whiteIntensity = frame0[5](frame0[7], frame1[7], lerpAmount)
      local players = {PLAYER_1, PLAYER_2}
      for _, player in ipairs(players) do
         if GAMESTATE:IsPlayerEnabled(player) then
            GAMESTATE:GetPlayerState(player):GetPlayerOptions("ModsLevel_Song"):Stealth(whiteIntensity * 0.5, 10000)
         end
      end

      gQuadAccum = gQuadAccum + deltaTime
      local secondsPerQuad = 1.0 / snowQuadsPerSecond
      while gQuadAccum >= secondsPerQuad do
         gQuadAccum = gQuadAccum -  secondsPerQuad

         if #PASSIVE_SNOW_QUADS > 0 then
            local snowQuad = PASSIVE_SNOW_QUADS[1]
            table.remove(PASSIVE_SNOW_QUADS, 1)
            local xRandWidth = 0.25
            local yRandWidth = 0.75
            ACTIVE_SNOW_QUADS[#ACTIVE_SNOW_QUADS+1] = { snowQuad, math.random() * (xRandWidth * 2) - xRandWidth, math.random() * (yRandWidth * 2) - yRandWidth }
            snowQuad:visible(1)

            local yProp = SCREEN_HEIGHT / ySpeed * -xSpeed
            local initPosX = math.random(0, (SCREEN_WIDTH + yProp))
            local initPosY = 0
            if initPosX > SCREEN_WIDTH then
               initPosY = (initPosX - SCREEN_WIDTH) / -xSpeed * ySpeed
               initPosX = SCREEN_WIDTH
            end

            snowQuad:x(initPosX)
            snowQuad:y(initPosY)
         end
      end

      local moveFrac = deltaTime * 60.0
      local quadCount = #ACTIVE_SNOW_QUADS
      local i = 1
      while i <= quadCount do
         local snowQuad = ACTIVE_SNOW_QUADS[i][1]
         local xSpeedDelta = ACTIVE_SNOW_QUADS[i][2]
         local ySpeedDelta = ACTIVE_SNOW_QUADS[i][3]
         snowQuad:x(snowQuad:GetX() + (xSpeed + xSpeedDelta) * moveFrac)
         snowQuad:y(snowQuad:GetY() + (ySpeed + ySpeedDelta) * moveFrac)

         if snowQuad:GetX() < 0 or snowQuad:GetY() >= SCREEN_HEIGHT then
            snowQuad:visible(0)
            table.remove(ACTIVE_SNOW_QUADS, i)
            PASSIVE_SNOW_QUADS[#PASSIVE_SNOW_QUADS+1] = snowQuad
            i = i - 1
            quadCount = quadCount - 1
         end

         i = i + 1
      end

      self:queuecommand('Update2')
   end,
   Update2Command=function(self)
      self:sleep(1.0 / 60.0)
      self:queuecommand('Update')
   end,
}

for i=1, 128 do
   mainFrame[#mainFrame+1] = Def.Sprite{
      Texture="snow1.png",
      InitCommand=function(self)
         self:stretchto(0, 0, SNOW_SMALL_SIZE * SNOW_RENDER_SCALE, SNOW_SMALL_SIZE * SNOW_RENDER_SCALE)
         SNOW_INIT(self)
      end,
   }

   mainFrame[#mainFrame+1] = Def.Sprite{
      Texture="snow2.png",
      InitCommand=function(self)
         self:stretchto(0, 0, SNOW_LARGE_SIZE * SNOW_RENDER_SCALE, SNOW_LARGE_SIZE * SNOW_RENDER_SCALE)
         SNOW_INIT(self)
      end,
   }
end

mainFrame[#mainFrame+1] = Def.Sprite{
   Texture="shroud.png",
   InitCommand=function(self)
      self:stretchto(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT)
      SHROUD_SPRITE = self
   end,
}

--[[]
mainFrame[#mainFrame+1] = Def.BitmapText{
   Font="Common normal"
   InitCommand=function(self)
      self:x(SCREEN_CENTER_X)
      self:y(SCREEN_HEIGHT / 40)
      self:queuecommand('Update')
   end,
   UpdateCommand=function(self)
      self:settext('Quads: ' .. #ACTIVE_SNOW_QUADS .. '/' .. (#ACTIVE_SNOW_QUADS + #PASSIVE_SNOW_QUADS))
      self:queuecommand('Update2')
   end,
   Update2Command=function(self)
      self:sleep(1.0 / 60.0)
      self:queuecommand('Update')
   end,
}
--]]

return mainFrame
